
IF NOT EXISTS
(
    SELECT *
    FROM INFORMATION_SCHEMA.TABLES
    WHERE TABLE_NAME = '[ADM_ERRO_CONSOLID_EST_ORC]'
)
BEGIN
		SET ANSI_NULLS ON;
        SET QUOTED_IDENTIFIER ON;
		
        CREATE TABLE [dbo].[ADM_ERRO_CONSOLID_EST_ORC]
		([CD_CONTROLE]  [BIGINT] IDENTITY(1, 1) NOT NULL,
		 [CD_EMP]       [INT] NULL,
		 [CD_FILIAL]    [INT] NULL,
		 [CD_ORC]       [BIGINT] NULL,
		 [DT_EMI_ORC]   [DATE] NULL,
		 [JSON_ENVIADO] VARCHAR (MAX) NULL,
		 [LAUDO]        VARCHAR (500) NULL,
		 [DT_CAD]       [DATETIME] NULL,
		 CONSTRAINT [PK_ADM_ERRO_CONSOLID_EST_ORC] PRIMARY KEY CLUSTERED([CD_CONTROLE] ASC)
		 WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
		)
        ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];
		
        CREATE NONCLUSTERED INDEX [ADM_ERRO_CONSOLID_EST_ORC_CDEMP_CDFILIAL_DTEMI] ON [dbo].[ADM_ERRO_CONSOLID_EST_ORC]([CD_EMP] ASC, [CD_FILIAL] ASC, [DT_EMI_ORC] ASC) WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];
        CREATE NONCLUSTERED INDEX [ADM_ERRO_CONSOLID_EST_ORC_DTCAD] ON [dbo].[ADM_ERRO_CONSOLID_EST_ORC]([DT_CAD] ASC) WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];
END;